/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class VWManageTrackersDialog
extends VWModalDialog {
    private VWTrkDataModel m_dataModel = null;
    private Vector m_origTrackers = null;
    private VWParticipantItem[] m_trackerItems = null;
    private VWWorkObject m_wob = null;
    private VWParticipant m_currentTracker = null;
    private VWParticipant m_currentUser = null;
    private IVWUsersAndGroupsPanel m_usersAndGroupsPanel = null;
    private JButton m_okButton = null;
    private ActionListener m_okButtonActionListener = null;
    private JButton m_cancelButton = null;
    private ActionListener m_cancelButtonActionListener = null;
    private JButton m_helpButton = null;
    private ActionListener m_helpButtonActionListener = null;
    private boolean m_bCanceled = true;
    private Frame m_parentFrame = null;

    public VWManageTrackersDialog(Frame parentFrame, VWTrkDataModel dataModel) {
        super(parentFrame);
        this.m_parentFrame = parentFrame;
        this.m_dataModel = dataModel;
        this.m_origTrackers = this.m_dataModel.getTrackerList();
        this.m_wob = this.m_dataModel.getInitialWorkObject();
        this.m_currentUser = this.m_dataModel.getCurrentUser();
        try {
            if (this.m_wob != null && this.m_wob.getIsTracker()) {
                this.m_currentTracker = this.m_wob.getParticipantNamePx();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        this.initData();
        this.setupLayout();
        this.updateControls();
    }

    protected void initData() {
        Object obj = null;
        Vector objToRemove = new Vector();
        Vector<VWParticipantItem> objToInit = new Vector<VWParticipantItem>();
        int index = 0;
        Object participantItem = null;
        boolean bFoundCurrentTracker = false;
        for (int i = 0; i < this.m_origTrackers.size(); ++i) {
            obj = this.m_origTrackers.elementAt(i);
            if (obj instanceof VWWorkObject) {
                try {
                    VWWorkObject tracker = (VWWorkObject)obj;
                    VWParticipant participant = tracker.getParticipantNamePx();
                    boolean bDuplicate = false;
                    for (int j = 0; j < objToInit.size(); ++j) {
                        if (objToInit.elementAt(j) == null || VWStringUtils.compare(participant.getParticipantName(), ((VWParticipantItem)objToInit.elementAt(j)).getShortName()) != 0) continue;
                        bDuplicate = true;
                        break;
                    }
                    if (bDuplicate) continue;
                    objToInit.addElement(new VWParticipantItem(participant));
                }
                catch (Exception ex) {
                    objToRemove.addElement(obj);
                    VWDebug.logException(ex);
                }
                continue;
            }
            objToRemove.addElement(obj);
        }
        this.m_trackerItems = new VWParticipantItem[objToInit.size()];
        objToInit.copyInto(this.m_trackerItems);
        if (objToRemove.size() > 0) {
            VWParticipantItem[] trackers = new VWParticipantItem[index];
            System.arraycopy(this.m_trackerItems, 0, trackers, 0, index);
            this.m_trackerItems = trackers;
            for (int i = 0; i < objToRemove.size(); ++i) {
                this.m_origTrackers.removeElement(objToRemove.elementAt(i));
            }
        }
    }

    private void addListeners() {
        this.m_okButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWManageTrackersDialog.this.m_bCanceled = false;
                try {
                    if (VWManageTrackersDialog.this.addRemoveTrackers()) {
                        VWManageTrackersDialog.this.setVisible(false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.m_okButton.addActionListener(this.m_okButtonActionListener);
        this.m_cancelButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWManageTrackersDialog.this.m_bCanceled = true;
                VWManageTrackersDialog.this.setVisible(false);
            }
        };
        this.m_cancelButton.addActionListener(this.m_cancelButtonActionListener);
        this.m_helpButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt039.htm");
            }
        };
        this.m_helpButton.addActionListener(this.m_helpButtonActionListener);
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_manageTrackersDialogDim);
        if (dim == null) {
            dim = new Dimension(450, 300);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_manageTrackers);
        try {
            this.m_usersAndGroupsPanel = VWDefaultSessionProxy.getSession().getSecurityDatabaseType() == 1 ? new VWFilteredUsersAndGroupsPanel(this, VWDefaultSessionProxy.getSession()) : new VWUsersAndGroupsPanel(VWDefaultSessionProxy.getSession(), true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_helpButton = new JButton(VWResource.s_help);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        mainPanel.add((Component)((JPanel)((Object)this.m_usersAndGroupsPanel)), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_cancelButton);
        buttonPanel.add(this.m_helpButton);
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.addListeners();
    }

    private void updateControls() {
        this.m_usersAndGroupsPanel.init(this.m_trackerItems);
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    private boolean addRemoveTrackers() {
        int i;
        int i2;
        boolean index = false;
        Vector<VWParticipant> trackersToAdd = new Vector<VWParticipant>();
        Vector trackersToRemove = (Vector)this.m_origTrackers.clone();
        VWParticipantItem[] participantItems = this.m_usersAndGroupsPanel.getParticipants();
        if (participantItems != null) {
            for (i2 = participantItems.length - 1; i2 >= 0; --i2) {
                VWParticipant participant = participantItems[i2].getVWParticipant();
                boolean bFound = false;
                for (int j = trackersToRemove.size() - 1; j >= 0; --j) {
                    try {
                        VWWorkObject tracker = (VWWorkObject)trackersToRemove.elementAt(j);
                        VWParticipant trackerParticipant = tracker.getParticipantNamePx();
                        if (!VWStringUtils.compareUsers(participant.getParticipantName(), trackerParticipant.getParticipantName())) continue;
                        bFound = true;
                        trackersToRemove.removeElementAt(j);
                        continue;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_manageTrackers, 0);
                        return false;
                    }
                }
                if (bFound) continue;
                trackersToAdd.insertElementAt(participant, 0);
            }
        }
        if (trackersToRemove.size() > 0) {
            for (i2 = 0; i2 < trackersToRemove.size(); ++i2) {
                VWWorkObject wob = (VWWorkObject)trackersToRemove.elementAt(i2);
                if (wob == null) continue;
                try {
                    VWParticipant participant = wob.getParticipantNamePx();
                    if (this.m_currentUser == null || !VWStringUtils.compareUsers(participant.getParticipantName(), this.m_currentUser.getParticipantName()) || !VWStringUtils.compareUsers(participant.getParticipantName(), this.m_currentTracker.getParticipantName()) || 1 != JOptionPane.showConfirmDialog(this, VWResource.s_okToDeleteSelfAsTracker, VWResource.s_manageTrackers, 0, 2)) continue;
                    VWParticipantItem[] trackers = null;
                    if (participantItems != null) {
                        trackers = new VWParticipantItem[participantItems.length + 1];
                        System.arraycopy(participantItems, 0, trackers, 0, participantItems.length);
                    } else {
                        trackers = new VWParticipantItem[1];
                    }
                    VWParticipant currentTracker = VWDefaultSessionProxy.getSession().fetchCurrentUserInfo().getNamePx();
                    trackers[trackers.length - 1] = new VWParticipantItem(currentTracker);
                    this.m_usersAndGroupsPanel.init(trackers);
                    return false;
                }
                catch (VWException e) {
                    VWDebug.logException(e);
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), VWResource.s_manageTrackers, 0);
                    return false;
                }
            }
        }
        try {
            this.m_dataModel.addTrackers(trackersToAdd);
        }
        catch (Exception e) {
            VWMessageDialog.showOptionDialog(this, e.getLocalizedMessage() + "\n" + VWResource.s_referToHelpForInfo, VWResource.s_manageTrackers, 1, 40, "general/vwfailedaddingtrackers.htm", null, 0, 0);
            return false;
        }
        Exception[] exceptions = this.m_dataModel.removeTrackers(trackersToRemove);
        if (exceptions != null && (i = 0) < exceptions.length) {
            JOptionPane.showMessageDialog(this, exceptions[i].getLocalizedMessage(), VWResource.s_manageTrackers, 0);
            return false;
        }
        return true;
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_dataModel = null;
        if (this.m_origTrackers != null) {
            this.m_origTrackers.removeAllElements();
            this.m_origTrackers = null;
        }
        if (this.m_trackerItems != null) {
            for (int i = 0; i < this.m_trackerItems.length; ++i) {
                this.m_trackerItems[i] = null;
            }
            this.m_trackerItems = null;
        }
        this.m_wob = null;
        this.m_currentTracker = null;
        this.m_currentUser = null;
        if (this.m_usersAndGroupsPanel != null) {
            this.m_usersAndGroupsPanel.removeReferences();
            this.m_usersAndGroupsPanel = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this.m_okButtonActionListener);
            this.m_okButton = null;
        }
        this.m_okButtonActionListener = null;
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this.m_cancelButtonActionListener);
            this.m_cancelButton = null;
        }
        this.m_cancelButtonActionListener = null;
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this.m_helpButtonActionListener);
            this.m_helpButton = null;
        }
        this.m_helpButtonActionListener = null;
        this.removeAll();
    }
}

